/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap.build.android;

import com.phonegap.build.DreamweaverBase;
import com.phonegap.build.android.AndroidDevice;
import com.phonegap.build.android.AndroidException;
import com.phonegap.build.android.AndroidShell;
import com.phonegap.build.android.AndroidTarget;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AndroidState
extends DreamweaverBase {
    public ArrayList<AndroidDevice> devices = new ArrayList();
    public ArrayList<AndroidTarget> targets = new ArrayList();
    public ArrayList<AndroidTarget> avds = new ArrayList();

    public static AndroidState GetCurrent(String sdkPath) throws AndroidException {
        String os = System.getProperty("os.name").toLowerCase();
        Boolean isMac = AndroidState.isMac();
        String androidExecutable = String.valueOf(sdkPath) + File.separator + "tools" + File.separator + "android" + (isMac != false ? "" : ".bat");
        String adbExecutable = String.valueOf(sdkPath) + File.separator + "platform-tools" + File.separator + "adb" + (isMac != false ? "" : ".exe");
        AndroidState.debug_log("Listing sdks");
        AndroidState.debug_log(androidExecutable);
        AndroidState.debug_log(adbExecutable);
        if (!new File(adbExecutable).exists()) {
            throw new AndroidException("noplatformtools");
        }
        AndroidState result = new AndroidState();
        Runtime rt = Runtime.getRuntime();
        String[] command = new String[]{androidExecutable, "list"};
        try {
            String line;
            Process p = rt.exec(command);
            StringBuilder rawTargets = new StringBuilder();
            StringBuilder rawAVDs = new StringBuilder();
            Boolean inTargets = false;
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                if ((line = String.valueOf(line) + "\n").contains("Available Android targets:")) {
                    inTargets = true;
                }
                if (line.contains("Available Android Virtual Devices:")) {
                    inTargets = false;
                }
                if (line.contains("could not be loaded:")) break;
                if (inTargets.booleanValue()) {
                    rawTargets.append(line);
                    continue;
                }
                rawAVDs.append(line);
            }
            input.close();
            p.waitFor();
            AndroidState.debug_log("Parsing sdks");
            AndroidState.debug_log("----------------");
            Pattern pattern1 = Pattern.compile("id: ([0-9]*)", 8);
            Pattern pattern2 = Pattern.compile("Name: (.*)", 8);
            Pattern pattern4 = Pattern.compile("Based on (.*)\\(.*?", 8);
            Pattern pattern5 = Pattern.compile("Target: (.*)\\(.*?", 8);
            String[] targets = rawTargets.toString().split("(?=\nid:)");
            int y = 0;
            while (y < targets.length) {
                Matcher m;
                String name = "";
                String version = "";
                if (!targets[y].contains("no ABIs.") && (m = pattern1.matcher(targets[y])).find()) {
                    name = m.group(1).trim();
                    m = pattern2.matcher(targets[y]);
                    if (m.find()) {
                        version = m.group(1).trim();
                    }
                    if ((m = pattern4.matcher(targets[y])).find()) {
                        version = String.valueOf(m.group(1).trim()) + " - " + version;
                    }
                    AndroidState.debug_log(String.valueOf(name) + " = " + version);
                    result.targets.add(new AndroidTarget(name, version));
                }
                ++y;
            }
            AndroidState.debug_log(" = ");
            String[] avds = rawAVDs.toString().split("(?=Name:)");
            int y2 = 0;
            while (y2 < avds.length) {
                String name = "";
                String version = "";
                Matcher m = pattern2.matcher(avds[y2]);
                if (m.find()) {
                    name = m.group(1).trim();
                    m = pattern5.matcher(avds[y2]);
                    if (m.find()) {
                        version = m.group(1).trim();
                    }
                    if ((m = pattern4.matcher(avds[y2])).find()) {
                        version = String.valueOf(m.group(1).trim()) + " - " + version;
                    }
                    AndroidState.debug_log(String.valueOf(name) + " = " + version);
                    result.avds.add(new AndroidTarget(name, version));
                }
                ++y2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        result.updateDevices(adbExecutable);
        AndroidState.debug_log("Returning result");
        return result;
    }

    public void updateDevices(String adbExecutable) {
        Runtime rt = Runtime.getRuntime();
        AndroidState.debug_log("Listing devices");
        String[] command = new String[]{adbExecutable, "devices"};
        ArrayList<String> devices = new ArrayList<String>();
        try {
            String line;
            Process p = rt.exec(command);
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = input.readLine()) != null) {
                if (line.trim().contentEquals("") || line.startsWith("*") || line.startsWith("List of")) continue;
                devices.add(line);
            }
            input.close();
        }
        catch (Exception p) {
            // empty catch block
        }
        AndroidState.debug_log("Parsing devices");
        int i = 0;
        while (i < devices.size()) {
            String serial;
            String device = (String)devices.get(i);
            if (device.startsWith("emulator")) {
                String name = serial = device.split("\\s+")[0];
                try {
                    int port = Integer.parseInt(device.split("\\s+")[0].split("-")[1]);
                    AndroidShell telnet = new AndroidShell("localhost", port);
                    name = telnet.sendCommand("avd name").split("\n")[1].trim();
                    telnet.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.devices.add(new AndroidDevice(name, serial, false));
            } else {
                serial = device.split("\\s+")[0];
                this.devices.add(new AndroidDevice(serial, serial, true));
            }
            ++i;
        }
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject result = new JSONObject();
        JSONArray jsonTargets = new JSONArray();
        int i = 0;
        while (i < this.targets.size()) {
            jsonTargets.put(this.targets.get(i).toJSON());
            ++i;
        }
        JSONArray jsonAVDs = new JSONArray();
        int i2 = 0;
        while (i2 < this.avds.size()) {
            jsonAVDs.put(this.avds.get(i2).toJSON());
            ++i2;
        }
        JSONArray jsonDevices = new JSONArray();
        int i3 = 0;
        while (i3 < this.devices.size()) {
            jsonDevices.put(this.devices.get(i3).toJSON());
            ++i3;
        }
        result.put("targets", jsonTargets);
        result.put("avds", jsonAVDs);
        result.put("devices", jsonDevices);
        return result;
    }
}

